<?xml version="1.0" encoding="iso-8859-1"?>
<!--
  Conversion d'une reponse du WebdavGenerator en lments inJac
  comportement: 
  si vide, @title est remplac par @name
-->

<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xi="http://www.w3.org/2001/XInclude"
		xmlns:MD="http://esup-portail.org/injac">


<xsl:param name="webdavpath"/>
<xsl:param name="upnode"/>
<xsl:template match="/MD:response">

<includes>  
  <path><xsl:value-of select="$webdavpath"/></path>
    
  <!-- boucle sur tous les fichiers XML --><!-- or @getcontenttype='text/plain' or @getcontenttype='text/html'-->
  <xsl:for-each select="*[@resourcetype='F'][@getcontenttype='text/xml']">
  <xsl:variable name="src">
   <xsl:value-of select="substring-before($webdavpath, '/slide')"/><xsl:value-of select="@href"/>
   <!--xsl:value-of select="substring-after(@href, 'injacRoot')"/-->
  </xsl:variable>
  <file>
  	<name><xsl:value-of select="@name"/></name>
	<href><xsl:value-of select="@href"/></href>
  	<title><xsl:value-of select="@title"/></title>
	<include>
		<xi:include href="{$src}">
                    <xi:fallback/>
                </xi:include>
	</include>
  </file> 
 </xsl:for-each>
 <!-- boucle sur tous les fichiers texte --><!-- or @getcontenttype='text/plain' or @getcontenttype='text/html'-->
  <xsl:for-each select="*[@resourcetype='F'][@getcontenttype='text/plain']">
  <xsl:variable name="src">
   <xsl:value-of select="substring-before($webdavpath, '/slide')"/><xsl:value-of select="@href"/>
  </xsl:variable>
  <file>
  	<name><xsl:value-of select="@name"/></name>
	<href><xsl:value-of select="@href"/></href>
  	<title><xsl:value-of select="@title"/></title>
	<include>
		<text>
		<xi:include parse="text" href="{$src}">
                    <xi:fallback/>
                </xi:include>
		</text>
	</include>
  </file> 
 </xsl:for-each>
 
 <!-- boucle sur tous les fichiers html --><!-- or @getcontenttype='text/plain' or @getcontenttype='text/html'-->
  <xsl:for-each select="*[@resourcetype='F'][@getcontenttype='text/html']">
  <xsl:variable name="src">
   <xsl:value-of select="substring-before($webdavpath, '/slide')"/><xsl:value-of select="@href"/>
  </xsl:variable>
  <file>
  	<name><xsl:value-of select="@name"/></name>
	<href><xsl:value-of select="@href"/></href>
  	<title><xsl:value-of select="@title"/></title>
	<include>
		<text>
		<xi:include parse="text" href="{$src}">
                    <xi:fallback/>
                </xi:include>
		</text>
	</include>
  </file> 
 </xsl:for-each>
 
</includes>		
</xsl:template>  

</xsl:stylesheet>
